<?php

use App\Http\Controllers\PostController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\HistoryController;
use App\Http\Controllers\BlogController;
use App\Http\Controllers\BoardController;
use App\Http\Controllers\ChartController;
use App\Http\Controllers\CodeofcController;
use App\Http\Controllers\Contactcontroller;
use App\Http\Controllers\DboardController;
use App\Http\Controllers\GallaryController;
use App\Http\Controllers\JobController;
use App\Http\Controllers\PartnersController;
use App\Http\Controllers\PolicyContoller;
use App\Http\Controllers\ProjectController;
use App\Http\Controllers\SearchController;
use App\Http\Controllers\StplanController;
use App\Http\Controllers\WorkareaController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('aboutus', function () {
    return view('about');
});


Route::get('membership', function () {
    return view('membership');
});

Route::get('rfqrfp', function () {
    return view('rfqrfp');
});


Route::get('/', function () {
    return view('welcome');
});

Route::get('/dashboard', function () {
    return view('dashboard');
})->middleware(['auth'])->name('dashboard');




Route::resource('/blog', App\Http\Controllers\BlogController::class)->middleware(['auth'])-> parameters(['blog'=>'id']);
Route::resource('/blogs', App\Http\Controllers\PostController::class);
Route::resource('/', App\Http\Controllers\HomeController::class);
Route::get('/blogs/{blog}', [PostController::class, 'show'])->name('blog.show');
Route::get('/search', [PostController::class,'search']);
Route::resource('/home', App\Http\Controllers\HomeController::class)->middleware(['auth'])-> parameters(['home'=>'id']);
Route::get('/home/{home}', [HomeController::class, 'show'])->name('home.show');
Route::resource('/history', App\Http\Controllers\HistoryController::class)->middleware(['auth'])-> parameters(['history'=>'id']);
Route::get('/historyoforg', [HistoryController::class,'index']);
Route::resource('/codeofc', App\Http\Controllers\CodeofcController::class)->middleware(['auth'])-> parameters(['codeofc'=>'id']);
Route::get('/codeofconduct', [CodeofcController::class,'index']);
Route::resource('/policy', App\Http\Controllers\PolicyContoller::class)->middleware(['auth'])-> parameters(['policy'=>'id']);
Route::get('/policies', [PolicyContoller::class,'index']);
Route::resource('/stplan', App\Http\Controllers\StplanController::class)->middleware(['auth'])-> parameters(['stplan'=>'id']);
Route::get('/strategicplan', [StplanController::class,'index']);
Route::resource('/workarea', App\Http\Controllers\WorkareaController::class)->middleware(['auth'])-> parameters(['workarea'=>'id']);
Route::get('/workareas', [WorkareaController::class,'index']);
Route::resource('/partner', App\Http\Controllers\PartnersController::class)->middleware(['auth'])-> parameters(['partner'=>'id']);
Route::get('/partners', [PartnersController::class,'index']);
Route::resource('/contact', App\Http\Controllers\Contactcontroller::class)->middleware(['auth'])-> parameters(['contact'=>'id']);
Route::get('/contactus', [Contactcontroller::class,'index']);

Route::resource('/project', App\Http\Controllers\ProjectController::class)->middleware(['auth'])-> parameters(['project'=>'id']);
Route::get('/projects', [ProjectController::class,'index']);

Route::get('/boards', [ChartController::class,'index']);
Route::resource('/eboard', App\Http\Controllers\BoardController::class)->middleware(['auth'])-> parameters(['eboard'=>'id']);
Route::get('/executboard', [BoardController::class,'index']);
Route::resource('/dboard', App\Http\Controllers\DboardController::class)->middleware(['auth'])-> parameters(['dboard'=>'id']);
Route::get('/directboard', [DboardController::class,'index']);

Route::get('/gallary', [BlogController::class,'gallary']);

Route::resource('/chart', App\Http\Controllers\ChartController::class)->middleware(['auth'])-> parameters(['chart'=>'id']);


Route::resource('/job', App\Http\Controllers\JobController::class)->middleware(['auth'])-> parameters(['job'=>'id']);
Route::get('/jobs', [JobController::class,'index']);
Route::get('/jobs/{job}', [JobController::class, 'show'])->name('job.show');

Route::get('/search', [SearchController::class,'index'])->name('search'); 

