@extends('layouts.master')
@section('content')



<div id="first-slider">
    <div id="carousel-example-generic" class="carousel slide carousel-fade">
        <!-- Indicators -->
        <ol class="carousel-indicators">
            <li data-target="#carousel-example-generic" data-slide-to="0" class="active"></li>
            <li data-target="#carousel-example-generic" data-slide-to="1"></li>
            <li data-target="#carousel-example-generic" data-slide-to="2"></li>
        </ol>
        <!-- Wrapper for slides -->
        <div class="carousel-inner" role="listbox">
            <!-- Item 1 -->
            <div class="item active slide1"></div>
            <!-- Item 2 -->
            <div class="item slide2"> </div>
            <!-- Item 3 -->
            <div class="item slide3"> </div>
            <!-- End Item 3 -->
        </div>
        <!-- End Wrapper for slides-->
        <a class="left carousel-control" href="#carousel-example-generic" role="button" data-slide="prev">
            <i class="fa fa-angle-left"></i><span class="sr-only">Previous</span>
        </a>
        <a class="right carousel-control" href="#carousel-example-generic" role="button" data-slide="next">
            <i class="fa fa-angle-right"></i><span class="sr-only">Next</span>
        </a>
    </div>
</div>


<div class="about-sec">
    <div class="container my-4">
        <div class="row">
            <div class="col-12">
                <div class="vmv-head">
                    <div class="text-header">
                        <h3>BFANO's Vision, Mission and Core Values</h3>
                    </div>
                </div>
            </div>
            <div class="col-md-6 col-lg-4 col-sm-6 col-xs-12">
                <div class="vmv">
                    <div class="img">
                        <img src="{{('images/vision.jpg')}}" alt="">
                    </div>
                    <div class="text">
                        <div class="text-header">
                            <h3>Vision</h3>
                        </div>
                        <div class="text-body">
                            <h6>
                                To fulfill the needs of vulnerable Afghans and secure their right to equal opportunities and basic services.

                            </h6>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-6 col-lg-4 col-sm-6 col-xs-12">
                <div class="vmv">
                    <div class="img">
                        <img src="{{('images/mission.jpg')}}" alt="">
                    </div>
                    <div class="text">
                        <div class="text-header">
                            <h3>Mission</h3>
                        </div>
                        <div class="text-body">
                            <h6>
                                We work with vulnerable Afghans for their equality, education, health and life improvement.
                            </h6>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-6 col-lg-4 col-sm-6 col-xs-12">
                <div class="vmv">
                    <div class="img">
                        <img src="{{('images/value.jpg')}}" alt="">
                    </div>
                    <div class="text">
                        <div class="text-header">
                            <h3>Values</h3>
                        </div>
                        <div class="text-body">
                            <h6>
                                - Integrity - Accountability - Gender and Diversity - Community First - Empowerment

                            </h6>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<section id="about-sec">
    <div class="container m-4">
        <div class="row text-justify">
            @foreach ($homepost as $blog)
            @auth
            <hr>
            <div class="edit-delete">
                <div class="edit-delete-div">
                    <div>
                        <form action="{{route('home.destroy', $blog->id)}}" method="POSt">
                            @csrf
                            @method('delete')
                            <button type="submit" class="button">Delete</button>
                        </form>
                    </div>
                    |
                    <div>
                        <button class="button"><a href="{{route('home.edit', ['id'=>$blog->id])}}">Edit</a></button>
                    </div>
                </div>
            </div>
            @endauth
            <div class="cards-home">

                <h3>{{$blog->title}}</h3>
                <hr>
                {!!$blog->description!!}
            </div>
            @endforeach


            <hr>


        </div>
    </div>
</section>


<section id="about-sec">
    <div class="container m-4">
        <div class="row text-justify">
            <h3>Latest Activities</h3>
            <hr>


            @forelse ($activity as $blog)

            <div class="col-lg-4 col-md-6 col-sm-12">
                <div class="cards2">
                    <div class="activityimg">
                        <img src="{{ asset('images/images/'.$blog->image) }}" style="width: 100%;" alt="image">
                    </div>
                    <h5>{{$blog->title}}</h5> <span>{{$blog->date}}</span>
                </div>
                <button class="readmore-div"><a href="{{route('blog.show', $blog)}}">Read More</a></button>
            </div>

            @empty
            <h4>Here 3 Latest activity will appear while uploaded.</h4>
            @endforelse

        </div>
    </div>
</section>

@endsection