<?php

namespace App\Http\Controllers;

use App\Models\Workarea;
use Illuminate\Http\Request;

class WorkareaController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $workarea = Workarea::all();
        return view('workareas', compact('workarea'));
    }

    
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('workarea.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        $file = $request->file('image');
        $image ="";
        if (!empty($file)){
            $image = time()."." .$file->getClientOriginalExtension();
            $file->move('images/images',$image);
        }

    
        Workarea::create([
            'title' => $request->title,
            'description' => $request->description,
            'image' => $image
        ]);

        return redirect(url('/workareas'));

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $workarea=Workarea::find($id);
        return view('workarea.workarea', compact('workarea'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $workarea = Workarea::findOrFail($id);
        return view('workarea.edit', compact('workarea'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $workarea = Workarea::findOrFail($id);
        $workarea->update([
            'title' => $request->title,
            'description' => $request->description,
        ]);
        return redirect(url('/workareas'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $workarea = Workarea::find($id);
        $workarea->delete($id);
        return redirect(url('/workarea'));
    }
}
