<?php

namespace App\Http\Controllers;

use App\Models\Stplan;
use Illuminate\Http\Request;

class StplanController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $stplan = Stplan::all();
        return view('stplan', compact('stplan'));
    }

    
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('stplan.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        $file = $request->file('image');
        $image ="";
        if (!empty($file)){
            $image = time()."." .$file->getClientOriginalExtension();
            $file->move('images/images',$image);
        }

    
        Stplan::create([
            'title' => $request->title,
            'description' => $request->description,
            'image' => $image
        ]);

        return redirect(url('/stplan'));

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $stplan=Stplan::find($id);
        return view('stplan.stplan', compact('stplan'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $stplan = Stplan::findOrFail($id);
        return view('stplan.edit', compact('stplan'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $stplan = Stplan::findOrFail($id);
        $stplan->update([
            'title' => $request->title,
            'description' => $request->description,
        ]);
        return redirect(url('/stplan'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $stplan = Stplan::find($id);
        $stplan->delete($id);
        return redirect(url('/stplan'));
    }

}
