<?php

namespace App\Http\Controllers;

use App\Models\Project;
use Illuminate\Http\Request;

class ProjectController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $project = Project::latest()->paginate(12);
        return view('project', compact('project'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('project.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        $file = $request->file('image');
        $image ="";
        if (!empty($file)){
            $image = time()."." .$file->getClientOriginalExtension();
            $file->move('images/images',$image);
        }

    
        Project::create([
            'title' => $request->title,
            'start' => $request->start,
            'end' => $request->end,
            'donor' => $request->donor,
            'field' => $request->field,
            'location' => $request->location,
            'description' => $request->description,
            'image' => $image
        ]);

        return redirect(url('/project'));

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $project=Project::find($id);
        return view('project.project', compact('project'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $project = Project::findOrFail($id);
        return view('project.edit', compact('project'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $project = Project::findOrFail($id);
        $project->update([
            'title' => $request->title,
            'start' => $request->start,
            'end' => $request->end,
            'donor' => $request->donor,
            'field' => $request->field,
            'location' => $request->location,
            'description' => $request->description,
        ]);
        return redirect(url('/projects'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $project = Project::find($id);
        $project->delete($id);
        return redirect(url('/project'));
    }


    
}