<?php

namespace App\Http\Controllers;

use App\Models\Job;
use Illuminate\Http\Request;

class JobController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $job = Job::latest()->paginate(50);
        return view('jobs', compact('job'));
    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('job.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
 
        Job::create([
            'title' => $request->title,
            'location' => $request->location,
            'city' => $request->city,
            'nationality' => $request->nationality,
            'organ' => $request->organ,
            'category' => $request->category,
            'yearsofexp' => $request->yearsofexp,
            'emptype' => $request->emptype,
            'condue' => $request->condue,
            'salary' => $request->salary,
            'gender'=> $request->gender,
            'vacancy'=> $request->vacancy,
            'education'=> $request->education,
            'nomofjob'=> $request->nomofjob,
            'activation'=> $request->activation,
            'announce'=> $request->announce,
            'close'=> $request->close,
            'description' => $request->description,
        ]);

        return redirect(url('/jobs'));

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $job=Job::find($id);
        return view('job.job', compact('job'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $job = Job::findOrFail($id);
        return view('job.edit', compact('job'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $job = Job::findOrFail($id);
        $job->update([
            'title' => $request->title,
            'location' => $request->location,
            'city' => $request->city,
            'nationality' => $request->nationality,
            'organ' => $request->organ,
            'category' => $request->category,
            'yearsofexp' => $request->yearsofexp,
            'emptype' => $request->emptype,
            'condue' => $request->condue,
            'salary' => $request->salary,
            'gender'=> $request->gender,
            'vacancy'=> $request->vacancy,
            'education'=> $request->education,
            'nomofjob'=> $request->nomofjob,
            'activation'=> $request->activation,
            'announce'=> $request->announce,
            'close'=> $request->close,
            'description' => $request->description,
        ]);
        return redirect(url('/jobs'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $job = Job::find($id);
        $job->delete($id);
        return redirect(url('/job'));
    }


}
