<?php

namespace App\Http\Controllers;

use App\Models\Direct;
use Illuminate\Http\Request;

class DboardController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $direct = Direct::all();
        return view('directorative', compact('direct'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('direct.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        $file = $request->file('image');
        $image ="";
        if (!empty($file)){
            $image = time()."." .$file->getClientOriginalExtension();
            $file->move('images/images',$image);
        }

    
        Direct::create([
            'name' => $request->name,
            'position' => $request->position,
            'education' => $request->education,
            'phone' => $request->phone,
            'mail' => $request->mail,
            'description' => $request->description,
            'image' => $image
        ]);

        return redirect(url('/directboard'));

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $direct=Direct::find($id);
        return view('direct.direct', compact('direct'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $direct = Direct::findOrFail($id);
        return view('direct.edit', compact('direct'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $direct = Direct::findOrFail($id);
        $direct->update([
            'name' => $request->name,
            'position' => $request->position,
            'education' => $request->education,
            'phone' => $request->phone,
            'mail' => $request->mail,
            'description' => $request->description,
        ]);
        return redirect(url('/directboard'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $direct = Direct::find($id);
        $direct->delete($id);
        return redirect(url('/directboard'));
    }
}
