<?php

namespace App\Http\Controllers;

use App\Models\Codeofc;
use Illuminate\Http\Request;

class CodeofcController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $codeofc = Codeofc::all();
        return view('codeofc', compact('codeofc'));
    }

    
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('codeofc.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        $file = $request->file('image');
        $image ="";
        if (!empty($file)){
            $image = time()."." .$file->getClientOriginalExtension();
            $file->move('images/images',$image);
        }

    
        Codeofc::create([
            'title' => $request->title,
            'description' => $request->description,
            'image' => $image
        ]);

        return redirect(url('/codeofc'));

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $codeofc=Codeofc::find($id);
        return view('codeofc.codeofc', compact('codeofc'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $codeofc = Codeofc::findOrFail($id);
        return view('codeofc.edit', compact('codeofc'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $history = Codeofc::findOrFail($id);
        $history->update([
            'title' => $request->title,
            'description' => $request->description,
        ]);
        return redirect(url('/codeofc'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $codeofc = Codeofc::find($id);
        $codeofc->delete($id);
        return redirect(url('/codeofc'));
    }

}