<?php

namespace App\Http\Controllers;

use App\Models\Execut;
use Illuminate\Http\Request;

class BoardController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $execut = Execut::all();
        return view('executive', compact('execut'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('execut.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        $file = $request->file('image');
        $image ="";
        if (!empty($file)){
            $image = time()."." .$file->getClientOriginalExtension();
            $file->move('images/images',$image);
        }

    
        Execut::create([
            'name' => $request->name,
            'position' => $request->position,
            'education' => $request->education,
            'phone' => $request->phone,
            'mail' => $request->mail,
            'description' => $request->description,
            'image' => $image
        ]);

        return redirect(url('/executboard'));

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $execut=Execut::find($id);
        return view('execut.execut', compact('execut'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $execut = Execut::findOrFail($id);
        return view('execut.edit', compact('execut'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $execut = Execut::findOrFail($id);
        $execut->update([
            'name' => $request->name,
            'position' => $request->position,
            'education' => $request->education,
            'phone' => $request->phone,
            'mail' => $request->mail,
            'description' => $request->description,
        ]);
        return redirect(url('/executboard'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $execut = Execut::find($id);
        $execut->delete($id);
        return redirect(url('/executboard'));
    }
}
